TITLE   'Steady Heat Conduction'			                    { 3d227.pde }
SELECT     errlim=1e-3     ngrid=1     spectral_colors	
COORDINATES   cartesian3				{ Student Edition }	
VARIABLES   temp
DEFINITIONS
   L=0.1     r0=0.015     z0=0.02			{ Plate thickness=z0 }
   k     heat=0             		{ Thermal conductivity and power density }
   in_fluxd=1e6			{ Input heat flux density at top }
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_x, fluxd_y, fluxd_z)     fluxdm=magnitude( fluxd)
EQUATIONS
   div( fluxd)=heat
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=0	
   layer 'iron'	 					
   surface 'middle' z=z0					{ Interface }
   layer 'copper'						
   surface 'top' z=L
BOUNDARIES
   surface 'bottom'  natural( temp)=0		{ Insulated }
   surface 'top'  natural( temp)=-in_fluxd	{ Input flux density }
region 'domain'    					{ Full solution domain }	
   layer 'iron'    k=82					{ Thermal conductivity }
   layer 'copper'  void
   start 'outer' (0,0)   natural( temp)=0
      line to (L,0)   value( temp)=300   line to (L,L)  to (0,L)  close
region 'cylinder'							
   layer 'iron'    k=82					{ Thermal conductivity }
   layer 'copper'   k=400				{ Redefine void }
   start (L/4+r0,L/4)  arc( center=L/4,L/4) angle=360
PLOTS
   grid( x,y,z)
   contour( temp) on x=y     contour( fluxdm) painted on x=y
   vector( fluxd) norm on x=y     vector( fluxd) norm on z=0
   contour( temp) on y=0     contour( temp) on y=L/4
   contour( temp) on x=L/4
   contour( temp) on z=z0 on 'iron'    contour( temp) on z=0
END

